/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.world.level.block.entity;

import fuzs.visualworkbench.registry.ModRegistry;
import fuzs.visualworkbench.world.inventory.ModCraftingMenu;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public class CraftingTableBlockEntity
extends class_2624 {
    private static final String LAST_RECIPE_ID_TAG = "LastRecipeId";
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private int lastResultId;
    public int combinedLight;
    public int ticks;
    public float currentAngle;
    public float nextAngle;
    private byte sector;
    private boolean animating;
    private float animationAngleStart;
    private float animationAngleEnd;
    private double startTicks;
    private double playerAngle;
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return index == 0 ? CraftingTableBlockEntity.this.getLastResultId() : 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                CraftingTableBlockEntity.this.setLastResultId(value);
            }
        }

        public int method_17389() {
            return 1;
        }
    };

    public CraftingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(ModRegistry.CRAFTING_TABLE_BLOCK_ENTITY, pos, state);
    }

    protected class_2561 method_17823() {
        return new class_2588("container.crafting");
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.inventory.clear();
        class_1262.method_5429((class_2487)tag, this.inventory);
        this.lastResultId = tag.method_10550(LAST_RECIPE_ID_TAG);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5427((class_2487)tag, this.inventory, (boolean)true);
        tag.method_10569(LAST_RECIPE_ID_TAG, this.lastResultId);
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.inventory) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        return index >= 0 && index < this.inventory.size() ? (class_1799)this.inventory.get(index) : class_1799.field_8037;
    }

    public class_1799 method_5434(int index, int count) {
        class_1799 itemStack = class_1262.method_5430(this.inventory, (int)index, (int)count);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 method_5441(int index) {
        class_1799 itemStack = class_1262.method_5428(this.inventory, (int)index);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public void method_5447(int index, class_1799 stack) {
        if (index >= 0 && index < this.inventory.size()) {
            this.inventory.set(index, (Object)stack);
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.method_10997().method_8321(this.field_11867) != this) {
            return false;
        }
        return !(player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > 64.0);
    }

    protected class_1703 method_5465(int id, class_1661 playerInventory) {
        return new ModCraftingMenu(id, playerInventory, (class_1263)this, class_3914.method_17392((class_1937)this.method_10997(), (class_2338)this.method_11016()), this.dataAccess);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public int getLastResultId() {
        return this.lastResultId;
    }

    private void setLastResultId(int lastResultId) {
        this.lastResultId = lastResultId;
        this.method_5431();
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, CraftingTableBlockEntity pBlockEntity) {
        byte sector;
        if (pBlockEntity.method_5442()) {
            return;
        }
        pBlockEntity.combinedLight = pBlockEntity.method_10997() != null ? CraftingTableBlockEntity.getLightColor((class_1920)pLevel, pBlockEntity.method_11016().method_10084()) : 0xF000F0;
        ++pBlockEntity.ticks;
        class_1657 playerentity = pLevel.method_18459((double)pBlockEntity.field_11867.method_10263() + 0.5, (double)pBlockEntity.field_11867.method_10264() + 0.5, (double)pBlockEntity.field_11867.method_10260() + 0.5, 3.0, false);
        if (playerentity != null) {
            double d0 = playerentity.method_23317() - ((double)pBlockEntity.field_11867.method_10263() + 0.5);
            double d1 = playerentity.method_23321() - ((double)pBlockEntity.field_11867.method_10260() + 0.5);
            pBlockEntity.playerAngle = (Math.atan2(-d0, -d1) + 3.9269908169872414) % (Math.PI * 2);
        }
        if (pBlockEntity.sector != (sector = (byte)(pBlockEntity.playerAngle * 2.0 / Math.PI))) {
            pBlockEntity.animating = true;
            pBlockEntity.animationAngleStart = pBlockEntity.currentAngle;
            float delta1 = (float)sector * 90.0f - pBlockEntity.currentAngle;
            float abs1 = Math.abs(delta1);
            float delta2 = delta1 + 360.0f;
            float shift = Math.abs(delta2);
            float delta3 = delta1 - 360.0f;
            float abs3 = Math.abs(delta3);
            pBlockEntity.animationAngleEnd = abs3 < abs1 && abs3 < shift ? delta3 + pBlockEntity.currentAngle : (shift < abs1 && shift < abs3 ? delta2 + pBlockEntity.currentAngle : delta1 + pBlockEntity.currentAngle);
            pBlockEntity.startTicks = pBlockEntity.ticks;
            pBlockEntity.sector = sector;
        }
        if (pBlockEntity.animating) {
            if ((double)pBlockEntity.ticks >= pBlockEntity.startTicks + 20.0) {
                pBlockEntity.animating = false;
                pBlockEntity.currentAngle = pBlockEntity.nextAngle = (pBlockEntity.animationAngleEnd + 360.0f) % 360.0f;
            } else {
                pBlockEntity.currentAngle = (CraftingTableBlockEntity.easeOutQuad((double)pBlockEntity.ticks - pBlockEntity.startTicks, pBlockEntity.animationAngleStart, pBlockEntity.animationAngleEnd - pBlockEntity.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                pBlockEntity.nextAngle = (CraftingTableBlockEntity.easeOutQuad(Math.min((double)(pBlockEntity.ticks + 1) - pBlockEntity.startTicks, 20.0), pBlockEntity.animationAngleStart, pBlockEntity.animationAngleEnd - pBlockEntity.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                if (pBlockEntity.currentAngle != 0.0f || pBlockEntity.nextAngle != 0.0f) {
                    if (pBlockEntity.currentAngle == 0.0f && pBlockEntity.nextAngle >= 180.0f) {
                        pBlockEntity.currentAngle = 360.0f;
                    }
                    if (pBlockEntity.nextAngle == 0.0f && pBlockEntity.currentAngle >= 180.0f) {
                        pBlockEntity.nextAngle = 360.0f;
                    }
                }
            }
        }
    }

    private static float easeOutQuad(double t, float b, float c, double d) {
        float z = (float)t / (float)d;
        return -c * z * (z - 2.0f) + b;
    }

    public static int getLightColor(class_1920 displayReader, class_2338 pos) {
        return CraftingTableBlockEntity.getLightColor(displayReader, displayReader.method_8320(pos), pos);
    }

    public static int getLightColor(class_1920 displayReader, class_2680 state, class_2338 pos) {
        int k;
        if (state.method_26208((class_1922)displayReader, pos)) {
            return 0xF000F0;
        }
        int i = displayReader.method_8314(class_1944.field_9284, pos);
        int j = displayReader.method_8314(class_1944.field_9282, pos);
        if (j < (k = state.method_26213())) {
            j = k;
        }
        return i << 20 | j << 4;
    }
}

